﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using UUN;
using System.Data.SqlClient;
using System.IO;
using System.Text;
using System.Text.RegularExpressions;
using System.Net;
using System.Xml;

public partial class Admin_NeiRong_WenZhang_XiuGai : System.Web.UI.Page
{
    private 访问 访问;
    private new int ID;
    protected String 分类代码;
    protected void Page_Load(object sender, EventArgs e)
    {
        访问 = new 访问(this.Context);
        访问.开始处理("修改文章", "网站后台", "修改文章", new 访问.回调委托(ZhiXing));
        访问.关闭连接();
    }

    private void ZhiXing()
    {
        访问.验证管理员();
        ID = Convert.ToInt32(Request.QueryString["ID"]);

        if (this.IsPostBack)
            修改文章();
        else
            初始化文章();
    }

    private String 保存网络图片(String 文章正文, int ID, ref String 资源文件)
    {
        if (文章正文.IndexOf("(img)") != -1)
            文章正文 = 保存网络图片_UBB(文章正文, "\\(img\\)(?<url>.+?)\\(/img\\)", ID, ref 资源文件);
        if (文章正文.IndexOf("[img]") != -1)
            文章正文 = 保存网络图片_UBB(文章正文, "\\[img\\](?<url>.+?)\\[/img\\]", ID, ref 资源文件);
        if (文章正文.IndexOf("{img}") != -1)
            文章正文 = 保存网络图片_UBB(文章正文, "\\{img\\}(?<url>.+?)\\{/img\\}", ID, ref 资源文件);
        return 文章正文;
    }

    private String 保存网络图片_UBB(String 文章正文, String _表达式, int ID, ref String 资源文件)
    {
        Regex 表达式 = new Regex(_表达式);
        MatchCollection JGS = 表达式.Matches(文章正文);
        for (int i = 0; i < JGS.Count; i++)
        {
            Match JG = JGS[i];
            String 地址 = JG.Groups["url"].Value;
            String 后缀 = Path.GetExtension(地址).Substring(1);
            if (地址.StartsWith("http://", StringComparison.OrdinalIgnoreCase) && 常用.是否允许后缀("gif,jpg,jpe,jpeg,png,tif,tiff,bmp", 后缀))
            {
                String 随机值 = "T" + ID + 常用.随机字符(30);
                String 文件名 = 程序.安装位置 + "Data/DT_WenZhang/IMG_" + (ID / 500) + "/" + 随机值 + "." + 后缀;
                常用.下载文件(地址, Server.MapPath(文件名));
                文章正文 = 文章正文.Replace(JG.Value, "[img]" + 文件名 + "[/img]");
                资源文件 += 资源文件 == "" ? "" : ",";
                资源文件 += 文件名;
            }
        }
        return 文章正文;
    }

    private void 初始化文章()
    {

        SqlCommand 语句 = new SqlCommand("SELECT [ID],[所属栏目],[标题],[标题样式_粗体],[标题样式_斜体],[标题样式_删除线],[标题样式_颜色],[是否推荐],[外部链接],[发布时间],[作者],[文章来源],[文章简介],[是否手动分页],[是否UBB],[是否关闭评论],[内容模板],[3G内容模板],[评论模板],[3G评论模板],[权限_仅限会员],[权限_需要等级],[权限_扣除积分],[文件资源] FROM [" + 程序.数据表前缀 + "内容_文章_文章] WHERE [是否删除]=@是否删除 AND [ID]=" + this.ID, 访问.连接);
        语句.Parameters.Add("@是否删除", SqlDbType.Bit).Value = false;
        Hashtable 文章 = 常用.SQL_获取(语句);

        if (文章 == null)
            throw new Exception("文章不存在");

        语句 = new SqlCommand("SELECT [栏目名称] FROM ["+程序.数据表前缀+"内容_栏目] WHERE [ID]=" + Convert.ToInt32(文章["所属栏目"]), 访问.连接);
        SqlDataReader _读取 = 语句.ExecuteReader();
        if (_读取.Read())
            分类代码 = "<a href=\""+Server.HtmlEncode(Request.QueryString["rurl"])+"\">"+Convert.ToString(_读取["栏目名称"]) + "</a> &gt;";
        else
        {
            _读取.Close();
            throw new Exception("内容栏目不存在");
        }
        _读取.Close();
        NeiRongMoBan.Items.Add(new ListItem("默认模板", "0"));
        NeiRongMoBan_3G.Items.Add(new ListItem("默认模板", "0"));
        PingLunMoBan.Items.Add(new ListItem("默认模板", "0"));
        PingLunMoBan_3G.Items.Add(new ListItem("默认模板", "0"));

        FileInfo[] FIS = new DirectoryInfo(Server.MapPath("~/Template/Content/" + 程序.设置["默认模板"] + "/Content/")).GetFiles();

        for (int i = 0; i < FIS.Length; i++)
        {
            int ID = 0;
            String 模板名称 = "";
            String 模板类型 = "";
            String _内容类型 = "";
            bool 是否WAP = true;

            XmlReader 读取 = XmlReader.Create(FIS[i].OpenRead());
            while (读取.Read())
                if (读取.NodeType == XmlNodeType.Element)
                    if (读取.Name == "set")
                        if (读取.GetAttribute("name") == "ID")
                            ID = Convert.ToInt32(读取.GetAttribute("value"));
                        else if (读取.GetAttribute("name") == "模板名称")
                            模板名称 = 读取.GetAttribute("value");
                        else if (读取.GetAttribute("name") == "模板类型")
                            模板类型 = 读取.GetAttribute("value");
                        else if (读取.GetAttribute("name") == "内容类型")
                            _内容类型 = 读取.GetAttribute("value");
                        else if (读取.GetAttribute("name") == "是否WAP")
                            是否WAP = Convert.ToBoolean(读取.GetAttribute("value"));
            读取.Close();

            if (_内容类型 == "文章")
                switch (模板类型)
                {
                    case "查看内容":
                        if (是否WAP)
                            NeiRongMoBan.Items.Add(new ListItem(模板名称, ID.ToString()));
                        else
                            NeiRongMoBan_3G.Items.Add(new ListItem(模板名称, ID.ToString()));
                        break;
                    case "评论列表":
                        if (是否WAP)
                            PingLunMoBan.Items.Add(new ListItem(模板名称, ID.ToString()));
                        else
                            PingLunMoBan_3G.Items.Add(new ListItem(模板名称, ID.ToString()));
                        break;
                }
        }

        BiaoTi.Text = Convert.ToString(文章["标题"]);
        BiaoTiYangShi_YanSe.Text = Convert.ToString(文章["标题样式_颜色"]);
        BiaoTiYangShi_ChuTi.Checked = Convert.ToBoolean(文章["标题样式_粗体"]);
        BiaoTiYangShi_XieTi.Checked = Convert.ToBoolean(文章["标题样式_斜体"]);
        BiaoTiYangShi_ShanChuXian.Checked = Convert.ToBoolean(文章["标题样式_删除线"]);
        ShiFouTuiJian.Checked = Convert.ToBoolean(文章["是否推荐"]);
        WaiBuLianJie.Text = Convert.ToString(文章["外部链接"]);
        FaBuShiJian.Text = Convert.ToString(文章["发布时间"]);
        WenZhangLaiYuan.Text = Convert.ToString(文章["文章来源"]);
        ZuoZhe.Text = Convert.ToString(文章["作者"]);
        WenZhangJianJie.Text = Convert.ToString(文章["文章简介"]);
        WenZhangZhengWen.Text = File.ReadAllText(Server.MapPath("~/Data/DT_WenZhang/" + (this.ID / 500) + "/" + this.ID + ".txt"), Encoding.UTF8);
        ShiFouGuanBiPingLun.Checked = Convert.ToBoolean(文章["是否关闭评论"]);
        ShiFouUBB.Checked = Convert.ToBoolean(文章["是否UBB"]);
        ShiFouShouDongFenYe.Checked = Convert.ToBoolean(文章["是否手动分页"]);
        NeiRongMoBan.SelectedValue = Convert.ToString(文章["内容模板"]);
        NeiRongMoBan_3G.SelectedValue = Convert.ToString(文章["3G内容模板"]);
        PingLunMoBan.Text = Convert.ToString(文章["评论模板"]);
        PingLunMoBan_3G.SelectedValue = Convert.ToString(文章["3G评论模板"]);
        QuanXian_JinXiaoHuiYuan.Checked = Convert.ToBoolean(文章["权限_仅限会员"]);
        QuanXian_XuYaoDenJi.Text = Convert.ToString(文章["权限_需要等级"]);
        QuanXian_KouChuJiFen.Text = Convert.ToString(文章["权限_扣除积分"]);
        SuoYouZiYuan.Value = Convert.ToString(文章["文件资源"]);
    }

    private void 修改文章()
    {
        访问.验证权限("10");
        ID = Convert.ToInt32(Request.QueryString["ID"]);

        String 标题 = BiaoTi.Text;
        String 标题样式_颜色 = BiaoTiYangShi_YanSe.Text;
        bool 标题样式_粗体 = BiaoTiYangShi_ChuTi.Checked;
        bool 标题样式_斜体 = BiaoTiYangShi_XieTi.Checked;
        bool 标题样式_删除线 = BiaoTiYangShi_ShanChuXian.Checked;
        bool 是否推荐 = ShiFouTuiJian.Checked;
        String 外部链接 = WaiBuLianJie.Text;
        DateTime 发布时间 = Convert.ToDateTime(FaBuShiJian.Text);
        String 文章来源 = WenZhangLaiYuan.Text;
        String 作者 = ZuoZhe.Text;
        String 文章简介 = WenZhangJianJie.Text;
        String 文章正文 = WenZhangZhengWen.Text;
        bool 是否关闭评论 = ShiFouGuanBiPingLun.Checked;
        bool 是否UBB = ShiFouUBB.Checked;
        bool 是否手动分页 = ShiFouShouDongFenYe.Checked;
        int 内容模板 = Convert.ToInt32(NeiRongMoBan.SelectedValue);
        int 评论模板 = Convert.ToInt32(PingLunMoBan.SelectedValue);
        int 内容模板_3G = Convert.ToInt32(NeiRongMoBan_3G.SelectedValue);
        int 评论模板_3G = Convert.ToInt32(PingLunMoBan_3G.SelectedValue);
        bool 权限_仅限会员 = QuanXian_JinXiaoHuiYuan.Checked;
        int 权限_需要等级 = Convert.ToInt32(QuanXian_XuYaoDenJi.Text);
        int 权限_扣除积分 = Convert.ToInt32(QuanXian_KouChuJiFen.Text);
        String 所有资源 = SuoYouZiYuan.Value;

        if (标题.Length == 0)
            throw new Exception("文章标题不能为空");

        String 资源文件夹=程序.安装位置+"Data/DT_WenZhang/IMG_"+(ID/500)+"/";

        文章正文 = 文章正文.Replace("[img]->", "[img]" + 资源文件夹);
        文章正文 = 文章正文.Replace("[url=->", "[url=" + 资源文件夹);
        if (BaoCunTuPian.Checked)
            文章正文 = 保存网络图片(文章正文, ID,ref 所有资源);

        String[] 资源数组 = 所有资源.Split(new Char[] { ',' }, StringSplitOptions.RemoveEmptyEntries);

        for (int i = 0; i < 资源数组.Length; i++)
            if (File.Exists(Server.MapPath("~/Temp/" + 资源数组[i].Substring(2))))
                File.Move(Server.MapPath("~/Temp/" + 资源数组[i].Substring(2)),
                    Server.MapPath(资源文件夹 + 资源数组[i].Substring(2)));

        File.WriteAllText(Server.MapPath("~/Data/DT_WenZhang/" + (ID / 500) + "/" + ID + ".txt"), 文章正文, Encoding.UTF8);

        SqlCommand 语句 = new SqlCommand("UPDATE [" + 程序.数据表前缀 + "内容_文章_文章] SET [标题]=@标题" +
            ",[标题样式_粗体]=@标题样式_粗体" +
            ",[标题样式_斜体]=@标题样式_斜体" +
            ",[标题样式_删除线]=@标题样式_删除线" +
            ",[标题样式_颜色]=@标题样式_颜色" +
            ",[是否推荐]=@是否推荐" +
            ",[外部链接]=@外部链接" +
            ",[发布时间]=@发布时间" +
            ",[作者]=@作者" +
            ",[文章来源]=@文章来源" +
            ",[文章简介]=@文章简介" +
            ",[是否手动分页]=@是否手动分页" +
            ",[是否UBB]=@是否UBB" +
            ",[是否关闭评论]=@是否关闭评论" +
            ",[内容模板]=@内容模板" +
            ",[3G内容模板]=@3G内容模板"+
            ",[评论模板]=@评论模板" +
            ",[3G评论模板]=@3G评论模板"+
            ",[权限_仅限会员]=@权限_仅限会员" +
            ",[权限_需要等级]=@权限_需要等级" +
            ",[权限_扣除积分]=@权限_扣除积分" +
            ",[文件资源]=@文件资源"+
            " WHERE [ID]=@ID", 访问.连接);
        语句.Parameters.Add("@标题", SqlDbType.NVarChar).Value = 标题;
        语句.Parameters.Add("@标题样式_粗体", SqlDbType.Bit).Value = 标题样式_粗体;
        语句.Parameters.Add("@标题样式_斜体", SqlDbType.Bit).Value = 标题样式_斜体;
        语句.Parameters.Add("@标题样式_删除线", SqlDbType.Bit).Value = 标题样式_删除线;
        语句.Parameters.Add("@标题样式_颜色", SqlDbType.NVarChar).Value = 标题样式_颜色;
        语句.Parameters.Add("@是否推荐", SqlDbType.Bit).Value = 是否推荐;
        语句.Parameters.Add("@外部链接", SqlDbType.NVarChar).Value = 外部链接;
        语句.Parameters.Add("@发布时间", SqlDbType.DateTime).Value = 发布时间;
        语句.Parameters.Add("@作者", SqlDbType.NVarChar).Value = 作者;
        语句.Parameters.Add("@文章来源", SqlDbType.NVarChar).Value = 文章来源;
        语句.Parameters.Add("@文章简介", SqlDbType.NVarChar).Value = 文章简介;
        语句.Parameters.Add("@是否手动分页", SqlDbType.Bit).Value = 是否手动分页;
        语句.Parameters.Add("@是否UBB", SqlDbType.Bit).Value = 是否UBB;
        语句.Parameters.Add("@是否关闭评论", SqlDbType.Bit).Value = 是否关闭评论;
        语句.Parameters.Add("@内容模板", SqlDbType.Int).Value = 内容模板;
        语句.Parameters.Add("@3G内容模板", SqlDbType.Int).Value = 内容模板_3G;
        语句.Parameters.Add("@评论模板", SqlDbType.Int).Value = 评论模板;
        语句.Parameters.Add("@3G评论模板", SqlDbType.Int).Value = 评论模板_3G;
        语句.Parameters.Add("@权限_仅限会员", SqlDbType.Bit).Value = 权限_仅限会员;
        语句.Parameters.Add("@权限_需要等级", SqlDbType.Int).Value = 权限_需要等级;
        语句.Parameters.Add("@权限_扣除积分", SqlDbType.Int).Value = 权限_扣除积分;
        语句.Parameters.Add("@文件资源", SqlDbType.NVarChar).Value = 所有资源;
        语句.Parameters.Add("@ID", SqlDbType.Int).Value = ID;
        语句.ExecuteNonQuery();
        访问统计_管理记录 记录 = new 访问统计_管理记录(this.Context, 访问.连接);
        记录.记录("修改文章", 访问.用户["昵称"].ToString());

        Response.Redirect(Request.QueryString["rurl"]);
    }
}
